use "./input/imf_trade_monthly.dta", clear

gen ISOPAIR = iso_reference + iso_counterpart
rename date_y year

preserve

keep ISOPAIR year flow
rename flow export
order ISOPAIR year export
collapse (sum) export, by(ISOPAIR year) 

sa "./tmp/imf_export_clean_temp.dta", replace

restore

cap drop ISOPAIR
gen ISOPAIR = iso_counterpart + iso_reference

keep ISOPAIR year flow
rename flow import
order ISOPAIR year 
collapse (sum) import, by(ISOPAIR year) 

sa "./tmp/imf_import_clean_temp.dta", replace

sort ISOPAIR year
merge 1:1 ISOPAIR year using "./tmp/imf_export_clean_temp.dta"
drop _merge

gen trade_gross = export + import

sa "./output/imf_trade_clean_temp.dta", replace

erase "./tmp/imf_export_clean_temp.dta"
erase "./tmp/imf_import_clean_temp.dta"
